<?php
/*--------------------------------------------------------------
   Title.php 2021-05-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Option\Dropdown\Item;

use Gambio\Admin\Modules\Language\Model\ValueObjects\LanguageCode;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Features\HasLanguageCode;
use Webmozart\Assert\Assert;

class Title implements HasLanguageCode
{
    /**
     * @var string
     */
    private $value;
    
    /**
     * @var LanguageCode
     */
    private $languageCode;
    
    
    /**
     * Constructor.
     */
    private function __construct(LanguageCode $languageCode, string $value)
    {
        Assert::stringNotEmpty($value);
        
        $this->value        = $value;
        $this->languageCode = $languageCode;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(LanguageCode $languageCode, string $title): self
    {
        return new self($languageCode, $title);
    }
    
    
    /**
     * Return value.
     */
    public function value(): string
    {
        return $this->value;
    }
    
    
    /**
     * @inheritDoc
     */
    public function languageCode(): LanguageCode
    {
        return $this->languageCode;
    }
}